/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Tech
**
** DESCRIPTION:	Maintains technology levels
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef TECH_H
#define TECH_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
class ITechObserver;

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Tech_c_iMaxLevel = 3;
const int Tech_c_iMaxObservers = 4;

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum ETech
{
	eTech_None = -1,

	eTech_Science,
	eTech_Medicine,
	eTech_Alchemy,
	eTech_Restoration,
	eTech_Leadership,
	eTech_Nature,
	eTech_Magic,

	eTech_NumberOf
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CTech
{
public:

	//class structures
	struct SSaveState
	{
		int		m_iLevel[eTech_NumberOf];
	};

	struct STechPrice
	{
		int		m_iPrice[Tech_c_iMaxLevel];
	};

private:

	//class data
	static STechPrice	sm_sTechPrice[eTech_NumberOf];
	int					m_iLevel[eTech_NumberOf];

	ITechObserver *		m_pObserver[Tech_c_iMaxObservers];
	static int			sm_iNumObservers;

	//class methods
	//setup
	public:		CTech(void);
	public:		void Reset();
	public:		const bool LoadState(const SSaveState &sSaveState);
	public:		const bool SaveState(SSaveState &sSaveState) const;

	// process
	public:		void RegisterObserver(ITechObserver *pObserver);

	// access
	public:		const int Level(const ETech eTech) const;
	public:		void Advance(const ETech eTech);
	public:		const int UpgradePrice(const ETech eTech) const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CTech		Tech;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/